﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Inet.Viewer.Data
{
    /// <summary>
    /// Describes the state and percentual progress of a report on the server.
    /// </summary>
    public class ReportState
    {
        /// <summary>
        /// Create a state instance.
        /// </summary>
        /// <param name="text">the state as localized text</param>
        /// <param name="progress">the percentual total progress</param>
        public ReportState(string text, int progress)
        {
            Text = text;
            Progress = progress;
        }
        /// <summary>
        /// Gets the state as text.
        /// </summary>
        public string Text { get; private set; }
        /// <summary>
        /// Gets the percentual total progress.
        /// </summary>
        public int Progress { get; private set; }
    }
}
